/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.compatibility.CompatBase;
import jeresources.entry.AbstractVillagerEntry;
import jeresources.util.VillagersHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VillagerEntry
extends AbstractVillagerEntry<Villager> {
    private final VillagerProfession profession;

    public VillagerEntry(VillagerProfession profession, Int2ObjectMap<VillagerTrades.ItemListing[]> itemListings) {
        this.profession = profession;
        this.addITradeLists(itemListings);
    }

    @Override
    public Component getDisplayName() {
        return this.profession.name();
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    @Override
    public Villager getVillagerEntity() {
        if (this.entity == null) {
            this.entity = (AbstractVillager)EntityType.VILLAGER.create(CompatBase.getLevel(), EntitySpawnReason.LOAD);
            assert (this.entity != null);
            ((Villager)this.entity).setVillagerData(((Villager)this.entity).getVillagerData().withProfession(BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder((Object)this.profession)));
            ((Villager)this.entity).tick();
        }
        return (Villager)this.entity;
    }

    @Override
    public List<ItemStack> getPois() {
        return VillagersHelper.getPoiBlocks(this.profession.heldJobSite()).stream().map(blockstate -> new ItemStack((ItemLike)blockstate.getBlock())).collect(Collectors.toList());
    }

    @Override
    public boolean hasPois() {
        return !VillagersHelper.getPoiBlocks(this.profession.heldJobSite()).isEmpty();
    }

    @Override
    public boolean hasLevels() {
        return true;
    }
}

